// Plik implementacji klasy FeetInches
#include <cstdlib>  // Instrukcja wymagana przez funkcj abs().
#include "FeetInches.h"

//**************************************************************
// Definicja funkcji simplify(). Funkcja ta sprawdza,
// czy warto zmiennej inches jest wiksza od 12 lub
// mniejsza od 0. Jeeli jeden z warunkw jest speniony,
// liczba cali i stp jest dostosowywana do wymogw
// systemu miar. Na przykad miara 3 stopy i 14 cali
// jest zamieniana na 4 stopy i 2 cale, a miara 5 stp
// i -2 cale jest zamieniana na 4 stopy i 10 cali.
//**************************************************************

void FeetInches::simplify()
{
   if (inches >= 12)
   {
      feet += (inches / 12);
      inches = inches % 12;
   }
   else if (inches < 0)
   {
      feet -= ((abs(inches) / 12) + 1);
      inches = 12 - (abs(inches) % 12);
   }
}

//**********************************************
// Przeciony operator jednoargumentowy +
//**********************************************

FeetInches FeetInches::operator + (const FeetInches &right)
{
   FeetInches temp;

   temp.inches = inches + right.inches;
   temp.feet = feet + right.feet;
   temp.simplify();
   return temp;
}

//**********************************************
// Przeciony operator jednoargumentowy -
//**********************************************

FeetInches FeetInches::operator - (const FeetInches &right)
{
   FeetInches temp;

   temp.inches = inches - right.inches;
   temp.feet = feet - right.feet;
   temp.simplify();  
   return temp;
}

//*************************************************************
// Przeciony operator prefiksowy ++. Powoduje on zwikszenie 
// zmiennej inches. Funkcja zwraca powikszony obiekt.
//*************************************************************

FeetInches FeetInches::operator ++ ()
{
   ++inches;
   simplify();
   return *this;
}

//***************************************************************
// Przeciony operator sufiksowy ++. Powoduje on zwikszenie 
// zmiennej inches. Funkcja zwraca obiekt zanim zostanie
// powikszony.
//***************************************************************

FeetInches FeetInches::operator ++ (int)
{
   FeetInches temp(feet, inches);

   inches++;
   simplify();
   return temp;
}

//************************************************************
// Przeciony operator >. Zwraca true jeeli biecy obiekt
// jest wikszy od obiektu w argumencie right.
//************************************************************

bool FeetInches::operator > (const FeetInches &right)
{
   bool status;

   if (feet > right.feet)
      status = true;
   else if (feet == right.feet && inches > right.inches)
      status = true;
   else
      status = false;

   return status;
}

//************************************************************
// Przeciony operator <. Zwraca true jeeli biecy obiekt
// jest mniejszy od obiektu w argumencie right.
//************************************************************

bool FeetInches::operator < (const FeetInches &right)
{
   bool status;

   if (feet < right.feet)
      status = true;
   else if (feet == right.feet && inches < right.inches)
      status = true;
   else
      status = false;

   return status;
}

//*************************************************************
// Przeciony operator ==. Zwraca true jeeli biecy obiekt
// jest rwny obiektowi w argumencie right.
//*************************************************************

bool FeetInches::operator == (const FeetInches &right)
{
   bool status;

   if (feet == right.feet && inches == right.inches)
      status = true;
   else
      status = false;

   return status;
}

//*************************************************************
// Przeciony operator !=. Zwraca warto true jeeli biecy
// obiekt zawiera warto rn od wartoci zawartej w argumencie right.
//*************************************************************

bool FeetInches::operator != (const FeetInches &right)
{
  bool status;

  if (!operator==(right))
    status = true;
  else
    status = false;

  return status;
}

//********************************************************
// Przeciony operator << umoliwiajcy bezporednie wywietlanie
// zawartoci obiektu typu FeetInches za pomoc obiektu cout.
//********************************************************

ostream &operator<<(ostream &strm, const FeetInches &obj)
{
   strm << obj.feet << " stopy/stp, " << obj.inches << " cale/cali";
   return strm;
}

//********************************************************
// Przeciony operator >> umoliwiajcy bezporednie umieszczanie w obiekcie
// typu FeetInches danych wprowadzonych przez uytkownika z pomoc obiektu cin.
//********************************************************

istream &operator >> (istream &strm, FeetInches &obj)
{
   // Wprowadzenie przez uytkownika liczby stp
   cout << "Liczba stp: ";
   strm >> obj.feet;

   // Wprowadzenie przez uytkownika liczby cali
   cout << "Liczba cali: ";
   strm >> obj.inches;

   // Normalizacja wartoci
   obj.simplify();

   return strm;
}

//*************************************************************
// Funkcja konwertujca obiekt typu FeetInches
// na liczb typu double
//*************************************************************

FeetInches::operator double()
{
  double temp = feet;

  temp += (inches / 12.0);
  return temp;
}

//*************************************************************
// Funkcja konwertujca obiekt typu FeetInches
// na liczb typu int
//*************************************************************

FeetInches:: operator int()
{ 
   return feet; 
}